import { useState } from 'react'

const coaches = [
  {
    id: 1,
    name: "Dr. Sarah Johnson",
    specialty: "Career Development",
    rating: 4.9,
    experience: "10+ years in executive coaching",
    bio: "Helping professionals achieve their career goals through strategic planning and skill development."
  },
  {
    id: 2,
    name: "Michael Chen",
    specialty: "Leadership",
    rating: 4.7,
    experience: "8 years in leadership training",
    bio: "Specializing in transforming managers into inspiring leaders through evidence-based techniques."
  },
  {
    id: 3,
    name: "Emma Rodriguez",
    specialty: "Life Balance",
    rating: 4.8,
    experience: "12 years in wellness coaching",
    bio: "Helping clients find harmony between professional success and personal fulfillment."
  }
]

export default function Coaches() {
  const [searchTerm, setSearchTerm] = useState('')

  const filteredCoaches = coaches.filter(coach =>
    coach.name.toLowerCase().includes(searchTerm.toLowerCase()) ||
    coach.specialty.toLowerCase().includes(searchTerm.toLowerCase())
  )

  return (
    <div className="max-w-4xl mx-auto">
      <h1 className="text-3xl font-bold text-saddle-brown mb-6">Find Your Coach</h1>
      <div className="mb-6">
        <input
          type="text"
          placeholder="Search by name or specialty..."
          className="w-full p-3 border border-saddle-brown rounded"
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
      </div>
      <div className="space-y-6">
        {filteredCoaches.map(coach => (
          <div key={coach.id} className="bg-white p-6 rounded-lg shadow-md border border-saddle-brown">
            <div className="flex justify-between items-start">
              <div>
                <h2 className="text-2xl font-semibold text-saddle-brown">{coach.name}</h2>
                <p className="text-lg font-medium">{coach.specialty}</p>
                <p className="text-gray-600">{coach.experience}</p>
              </div>
              <div className="bg-saddle-brown text-white px-3 py-1 rounded">
                {coach.rating} ★
              </div>
            </div>
            <p className="mt-4">{coach.bio}</p>
            <div className="mt-6 flex justify-end space-x-3">
              <button className="px-4 py-2 border border-saddle-brown text-saddle-brown rounded hover:bg-saddle-brown hover:text-white transition">
                View Profile
              </button>
              <button className="px-4 py-2 bg-saddle-brown text-white rounded hover:bg-opacity-90 transition">
                Book Session
              </button>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}
