import { useState } from 'react'

export default function Goals() {
  const [goals, setGoals] = useState([
    { id: 1, text: 'Improve leadership skills', completed: false },
    { id: 2, text: 'Career advancement', completed: true },
    { id: 3, text: 'Better work-life balance', completed: false }
  ])
  const [newGoal, setNewGoal] = useState('')

  const addGoal = () => {
    if (newGoal.trim()) {
      setGoals([...goals, { id: Date.now(), text: newGoal, completed: false }])
      setNewGoal('')
    }
  }

  const toggleGoal = (id) => {
    setGoals(goals.map(goal => 
      goal.id === id ? { ...goal, completed: !goal.completed } : goal
    ))
  }

  return (
    <div className="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md border border-saddle-brown">
      <h1 className="text-3xl font-bold text-saddle-brown mb-6">My Goals</h1>
      
      <div className="mb-6 flex">
        <input
          type="text"
          value={newGoal}
          onChange={(e) => setNewGoal(e.target.value)}
          placeholder="Add a new goal..."
          className="flex-1 p-2 border border-saddle-brown rounded-l"
        />
        <button
          onClick={addGoal}
          className="px-4 py-2 bg-saddle-brown text-white rounded-r hover:bg-opacity-90 transition"
        >
          Add
        </button>
      </div>

      <ul className="space-y-3">
        {goals.map(goal => (
          <li key={goal.id} className="flex items-center">
            <input
              type="checkbox"
              checked={goal.completed}
              onChange={() => toggleGoal(goal.id)}
              className="h-5 w-5 text-saddle-brown rounded border-saddle-brown focus:ring-saddle-brown"
            />
            <span className={`ml-3 ${goal.completed ? 'line-through text-gray-500' : 'text-gray-800'}`}>
              {goal.text}
            </span>
          </li>
        ))}
      </ul>
    </div>
  )
}
