import { useState } from 'react'
import { useForm } from 'react-hook-form'

export default function Profile() {
  const { register, handleSubmit } = useForm()
  const [isEditing, setIsEditing] = useState(false)

  const onSubmit = (data) => {
    console.log(data)
    setIsEditing(false)
  }

  return (
    <div className="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md border border-saddle-brown">
      <div className="flex justify-between items-center mb-6">
        <h1 className="text-3xl font-bold text-saddle-brown">My Profile</h1>
        <button 
          onClick={() => setIsEditing(!isEditing)}
          className="px-4 py-2 border border-saddle-brown text-saddle-brown rounded hover:bg-saddle-brown hover:text-white transition"
        >
          {isEditing ? 'Cancel' : 'Edit Profile'}
        </button>
      </div>

      {isEditing ? (
        <form onSubmit={handleSubmit(onSubmit)} className="space-y-4">
          <div>
            <label className="block text-saddle-brown font-medium mb-1">Name</label>
            <input
              {...register('name')}
              className="w-full p-2 border border-saddle-brown rounded"
              defaultValue="John Doe"
            />
          </div>
          <div>
            <label className="block text-saddle-brown font-medium mb-1">Email</label>
            <input
              {...register('email')}
              className="w-full p-2 border border-saddle-brown rounded"
              defaultValue="john@example.com"
            />
          </div>
          <div>
            <label className="block text-saddle-brown font-medium mb-1">Bio</label>
            <textarea
              {...register('bio')}
              className="w-full p-2 border border-saddle-brown rounded"
              rows={4}
              defaultValue="I'm looking for a coach to help me with career advancement and leadership skills."
            />
          </div>
          <button
            type="submit"
            className="px-4 py-2 bg-saddle-brown text-white rounded hover:bg-opacity-90 transition"
          >
            Save Changes
          </button>
        </form>
      ) : (
        <div className="space-y-4">
          <div>
            <h2 className="text-xl font-semibold text-saddle-brown">John Doe</h2>
            <p className="text-gray-600">john@example.com</p>
          </div>
          <div>
            <h3 className="text-lg font-medium text-saddle-brown">About Me</h3>
            <p className="text-gray-700">
              I'm looking for a coach to help me with career advancement and leadership skills.
            </p>
          </div>
          <div>
            <h3 className="text-lg font-medium text-saddle-brown">Coaching Goals</h3>
            <ul className="list-disc pl-5 text-gray-700">
              <li>Improve leadership skills</li>
              <li>Career advancement</li>
              <li>Better work-life balance</li>
            </ul>
          </div>
        </div>
      )}
    </div>
  )
}
