import { useState } from 'react'
import Calendar from 'react-calendar'
import 'react-calendar/dist/Calendar.css'

export default function Schedule() {
  const [date, setDate] = useState(new Date())
  const [selectedTime, setSelectedTime] = useState(null)

  const availableTimes = [
    '09:00 AM', '10:30 AM', '12:00 PM',
    '02:00 PM', '03:30 PM', '05:00 PM'
  ]

  return (
    <div className="max-w-4xl mx-auto">
      <h1 className="text-3xl font-bold text-saddle-brown mb-6">Schedule a Session</h1>
      <div className="bg-white p-6 rounded-lg shadow-md border border-saddle-brown">
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <div>
            <h2 className="text-xl font-semibold text-saddle-brown mb-4">Select a Date</h2>
            <Calendar
              onChange={setDate}
              value={date}
              minDate={new Date()}
              className="border border-saddle-brown rounded p-2"
            />
          </div>
          <div>
            <h2 className="text-xl font-semibold text-saddle-brown mb-4">Available Times</h2>
            <div className="grid grid-cols-2 gap-3">
              {availableTimes.map(time => (
                <button
                  key={time}
                  onClick={() => setSelectedTime(time)}
                  className={`p-3 rounded border ${selectedTime === time 
                    ? 'bg-saddle-brown text-white' 
                    : 'border-saddle-brown text-saddle-brown hover:bg-saddle-brown hover:text-white'}`}
                >
                  {time}
                </button>
              ))}
            </div>
            {selectedTime && (
              <div className="mt-6">
                <button className="w-full py-3 bg-saddle-brown text-white rounded hover:bg-opacity-90 transition">
                  Confirm Booking for {date.toDateString()} at {selectedTime}
                </button>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  )
}
