import { useParams } from 'react-router-dom'
import styled from 'styled-components'

const Container = styled.div`
  padding: 20px;
  max-width: 1200px;
  margin: 0 auto;
  background-color: white;
  border-radius: 8px;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
`

const Title = styled.h1`
  color: steelblue;
`

export default function GroupDetail() {
  const { id } = useParams()

  return (
    <Container>
      <Title>Study Group Details</Title>
      <p>Group ID: {id}</p>
      {/* Add more group details here */}
    </Container>
  )
}
