import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Lobby from './pages/Lobby'
import GameTable from './pages/GameTable'
import Auth from './pages/Auth'
import Profile from './pages/Profile'

const theme = createTheme({
  palette: {
    background: {
      default: '#007FFF', // Azure
      paper: '#191970' // Midnight Blue
    },
    primary: {
      main: '#191970' // Midnight Blue
    },
    secondary: {
      main: '#007FFF' // Azure
    },
    text: {
      primary: '#ffffff',
      secondary: '#e0e0e0'
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Routes>
          <Route path="/" element={<Lobby />} />
          <Route path="/table/:id" element={<GameTable />} />
          <Route path="/auth" element={<Auth />} />
          <Route path="/profile" element={<Profile />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
