import React, { useState, useEffect } from 'react'
import { Box, Typography, Button, Card, CardContent, List, ListItem, ListItemText, TextField } from '@mui/material'
import { io } from 'socket.io-client'

const Lobby = () => {
  const [rooms, setRooms] = useState([])
  const [newRoomName, setNewRoomName] = useState('')
  const socket = io('http://localhost:5000')

  useEffect(() => {
    socket.on('rooms', (data) => {
      setRooms(data)
    })

    return () => {
      socket.disconnect()
    }
  }, [])

  const createRoom = () => {
    if (newRoomName.trim()) {
      socket.emit('createRoom', { name: newRoomName })
      setNewRoomName('')
    }
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>Texas Hold'em Lobby</Typography>
      
      <Box sx={{ display: 'flex', gap: 2, mb: 4 }}>
        <TextField
          label="New Room Name"
          value={newRoomName}
          onChange={(e) => setNewRoomName(e.target.value)}
          variant="outlined"
        />
        <Button variant="contained" onClick={createRoom}>Create Room</Button>
      </Box>

      <Typography variant="h6" gutterBottom>Available Rooms</Typography>
      <List>
        {rooms.map((room) => (
          <Card key={room.id} sx={{ mb: 2 }}>
            <CardContent>
              <ListItem>
                <ListItemText
                  primary={room.name}
                  secondary={`Players: ${room.players.length}/${room.maxPlayers}`}
                />
                <Button
                  variant="contained"
                  disabled={room.players.length >= room.maxPlayers}
                  onClick={() => joinRoom(room.id)}
                >
                  Join
                </Button>
              </ListItem>
            </CardContent>
          </Card>
        ))}
      </List>
    </Box>
  )
}

export default Lobby
