import { useState } from 'react'
import Question from '../components/Question'
import '../styles/Practice.css'

const questions = [
  {
    id: 1,
    text: "When approaching a stopped school bus with flashing red lights, you must:",
    options: [
      "Stop only if children are visible",
      "Stop at least 25 feet away",
      "Slow down and proceed with caution",
      "Stop only if you see the bus driver signal"
    ],
    answer: 1
  },
  // Add more questions...
]

export default function Practice() {
  const [currentQuestion, setCurrentQuestion] = useState(0)
  const [selectedOption, setSelectedOption] = useState(null)
  const [showAnswer, setShowAnswer] = useState(false)

  const handleNext = () => {
    setCurrentQuestion(prev => (prev + 1) % questions.length)
    setSelectedOption(null)
    setShowAnswer(false)
  }

  return (
    <div className="practice">
      <h2>Practice Questions</h2>
      <div className="question-container">
        <Question 
          question={questions[currentQuestion]}
          selectedOption={selectedOption}
          showAnswer={showAnswer}
          onSelect={setSelectedOption}
        />
        <div className="controls">
          <button 
            onClick={() => setShowAnswer(true)}
            disabled={selectedOption === null}
          >
            Check Answer
          </button>
          <button onClick={handleNext}>Next Question</button>
        </div>
      </div>
    </div>
  )
}
