const express = require('express')
const sqlite3 = require('sqlite3').verbose()
const multer = require('multer')
const cors = require('cors')
const path = require('path')
const fs = require('fs')

const app = express()
const port = 5000

// Middleware
app.use(cors())
app.use(express.json())
app.use('/uploads', express.static('uploads'))

// Database setup
const db = new sqlite3.Database('./database.db')

// Initialize database
db.serialize(() => {
  db.run(`
    CREATE TABLE IF NOT EXISTS obituaries (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT NOT NULL,
      birth_date TEXT,
      death_date TEXT,
      biography TEXT,
      funeral_details TEXT,
      image_path TEXT,
      created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )
  `)

  db.run(`
    CREATE TABLE IF NOT EXISTS mortuaries (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT NOT NULL,
      address TEXT,
      phone TEXT,
      website TEXT,
      services TEXT
    )
  `)

  db.run(`
    CREATE TABLE IF NOT EXISTS condolences (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      obituary_id INTEGER,
      author TEXT NOT NULL,
      message TEXT NOT NULL,
      created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
      FOREIGN KEY(obituary_id) REFERENCES obituaries(id)
    )
  `)
})

// File upload setup
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    const uploadDir = './uploads'
    if (!fs.existsSync(uploadDir)) {
      fs.mkdirSync(uploadDir)
    }
    cb(null, uploadDir)
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname))
  }
})

const upload = multer({ storage })

// Routes would be implemented here...

app.listen(port, () => {
  console.log(`Server running on port ${port}`)
})
