import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import PoetryList from './pages/PoetryList'
import PoetryDetail from './pages/PoetryDetail'
import PostPoetry from './pages/PostPoetry'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  return (
    <Router>
      <Navbar />
      <div className="app-container">
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/poems" element={<PoetryList />} />
          <Route path="/poems/:id" element={<PoetryDetail />} />
          <Route path="/post" element={<PostPoetry />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App
