import { useState } from 'react'
import { FaUser, FaBriefcase, FaGraduationCap, FaCode, FaEnvelope } from 'react-icons/fa'
import './App.css'

function App() {
  const [activeTab, setActiveTab] = useState('about')

  const personalInfo = {
    name: "Jane Doe",
    title: "Senior Software Developer",
    email: "jane.doe@example.com",
    phone: "+1 (555) 123-4567",
    location: "San Francisco, CA",
    about: "Experienced software developer with 5+ years of expertise in building web applications. Passionate about creating efficient, scalable solutions with clean code."
  }

  const workExperience = [
    {
      id: 1,
      position: "Senior Developer",
      company: "Tech Solutions Inc.",
      period: "2020 - Present",
      responsibilities: [
        "Lead development team of 5 engineers",
        "Architected new microservices infrastructure",
        "Improved application performance by 40%"
      ]
    },
    {
      id: 2,
      position: "Software Developer",
      company: "WebApps Co.",
      period: "2018 - 2020",
      responsibilities: [
        "Developed new features for SaaS platform",
        "Implemented CI/CD pipeline",
        "Mentored junior developers"
      ]
    }
  ]

  const education = [
    {
      id: 1,
      degree: "MSc Computer Science",
      institution: "Stanford University",
      year: "2018"
    },
    {
      id: 2,
      degree: "BSc Software Engineering",
      institution: "University of California",
      year: "2016"
    }
  ]

  const skills = [
    { id: 1, name: "JavaScript", level: 90 },
    { id: 2, name: "React", level: 85 },
    { id: 3, name: "Node.js", level: 80 },
    { id: 4, name: "HTML/CSS", level: 95 },
    { id: 5, name: "SQL", level: 75 }
  ]

  const projects = [
    {
      id: 1,
      name: "E-commerce Platform",
      description: "Full-stack e-commerce solution with payment integration",
      technologies: ["React", "Node.js", "MongoDB"]
    },
    {
      id: 2,
      name: "Task Management App",
      description: "Collaborative project management tool",
      technologies: ["Vue.js", "Firebase"]
    }
  ]

  return (
    <div className="app">
      <header className="header">
        <h1>{personalInfo.name}</h1>
        <h2>{personalInfo.title}</h2>
      </header>

      <nav className="nav">
        <button 
          onClick={() => setActiveTab('about')} 
          className={activeTab === 'about' ? 'active' : ''}
        >
          <FaUser /> About
        </button>
        <button 
          onClick={() => setActiveTab('experience')} 
          className={activeTab === 'experience' ? 'active' : ''}
        >
          <FaBriefcase /> Experience
        </button>
        <button 
          onClick={() => setActiveTab('education')} 
          className={activeTab === 'education' ? 'active' : ''}
        >
          <FaGraduationCap /> Education
        </button>
        <button 
          onClick={() => setActiveTab('skills')} 
          className={activeTab === 'skills' ? 'active' : ''}
        >
          <FaCode /> Skills
        </button>
        <button 
          onClick={() => setActiveTab('projects')} 
          className={activeTab === 'projects' ? 'active' : ''}
        >
          <FaCode /> Projects
        </button>
        <button 
          onClick={() => setActiveTab('contact')} 
          className={activeTab === 'contact' ? 'active' : ''}
        >
          <FaEnvelope /> Contact
        </button>
      </nav>

      <main className="main-content">
        {activeTab === 'about' && (
          <section className="about">
            <h2>About Me</h2>
            <p>{personalInfo.about}</p>
            <div className="contact-info">
              <p><strong>Email:</strong> {personalInfo.email}</p>
              <p><strong>Phone:</strong> {personalInfo.phone}</p>
              <p><strong>Location:</strong> {personalInfo.location}</p>
            </div>
          </section>
        )}

        {activeTab === 'experience' && (
          <section className="experience">
            <h2>Work Experience</h2>
            {workExperience.map(job => (
              <div key={job.id} className="job">
                <h3>{job.position} at {job.company}</h3>
                <p className="period">{job.period}</p>
                <ul>
                  {job.responsibilities.map((item, index) => (
                    <li key={index}>{item}</li>
                  ))}
                </ul>
              </div>
            ))}
          </section>
        )}

        {activeTab === 'education' && (
          <section className="education">
            <h2>Education</h2>
            {education.map(edu => (
              <div key={edu.id} className="education-item">
                <h3>{edu.degree}</h3>
                <p>{edu.institution} - {edu.year}</p>
              </div>
            ))}
          </section>
        )}

        {activeTab === 'skills' && (
          <section className="skills">
            <h2>Skills</h2>
            {skills.map(skill => (
              <div key={skill.id} className="skill-item">
                <div className="skill-info">
                  <span>{skill.name}</span>
                  <span>{skill.level}%</span>
                </div>
                <div className="skill-bar">
                  <div 
                    className="skill-level" 
                    style={{ width: `${skill.level}%`, backgroundColor: '#c71585' }}
                  ></div>
                </div>
              </div>
            ))}
          </section>
        )}

        {activeTab === 'projects' && (
          <section className="projects">
            <h2>Projects</h2>
            <div className="project-grid">
              {projects.map(project => (
                <div key={project.id} className="project-card">
                  <h3>{project.name}</h3>
                  <p>{project.description}</p>
                  <div className="technologies">
                    {project.technologies.map((tech, index) => (
                      <span key={index} className="tech-tag">{tech}</span>
                    ))}
                  </div>
                </div>
              ))}
            </div>
          </section>
        )}

        {activeTab === 'contact' && (
          <section className="contact">
            <h2>Contact Me</h2>
            <form className="contact-form">
              <div className="form-group">
                <label htmlFor="name">Name</label>
                <input type="text" id="name" placeholder="Your name" />
              </div>
              <div className="form-group">
                <label htmlFor="email">Email</label>
                <input type="email" id="email" placeholder="Your email" />
              </div>
              <div className="form-group">
                <label htmlFor="message">Message</label>
                <textarea id="message" placeholder="Your message"></textarea>
              </div>
              <button type="submit" className="btn">Send Message</button>
            </form>
          </section>
        )}
      </main>

      <footer className="footer">
        <p>&copy; {new Date().getFullYear()} {personalInfo.name}. All rights reserved.</p>
      </footer>
    </div>
  )
}

export default App
