import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Biography from './pages/Biography'
import SearchResults from './pages/SearchResults'
import Navbar from './components/Navbar'
import Footer from './components/Footer'

export default function App() {
  return (
    <Router>
      <Navbar />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/biography/:id" element={<Biography />} />
        <Route path="/search" element={<SearchResults />} />
      </Routes>
      <Footer />
    </Router>
  )
}
