import { Link } from 'react-router-dom'
import { FiSearch } from 'react-icons/fi'
import { useState } from 'react'
import { useNavigate } from 'react-router-dom'

export default function Navbar() {
  const [searchQuery, setSearchQuery] = useState('')
  const navigate = useNavigate()

  const handleSearch = (e) => {
    e.preventDefault()
    if (searchQuery.trim()) {
      navigate(`/search?q=${searchQuery}`)
      setSearchQuery('')
    }
  }

  return (
    <nav className="py-4 border-b border-gray-200">
      <div className="container flex justify-between items-center">
        <Link to="/" className="text-xl font-bold">Biography Archive</Link>
        <form onSubmit={handleSearch} className="flex items-center">
          <input
            type="text"
            placeholder="Search biographies..."
            className="px-4 py-2 border rounded-l-md focus:outline-none"
            value={searchQuery}
            onChange={(e) => setSearchQuery(e.target.value)}
          />
          <button
            type="submit"
            className="bg-gray-200 px-4 py-2 rounded-r-md hover:bg-gray-300 transition"
          >
            <FiSearch />
          </button>
        </form>
      </div>
    </nav>
  )
}
