import { useParams } from 'react-router-dom'
import { sampleBiographies } from '../data/sampleData'

export default function Biography() {
  const { id } = useParams()
  const person = sampleBiographies.find(p => p.id === parseInt(id))

  if (!person) {
    return <div className="container py-8">Person not found</div>
  }

  return (
    <div className="py-8">
      <div className="container">
        <div className="bg-white p-8 rounded-lg shadow-md">
          <div className="flex flex-col md:flex-row gap-8 mb-8">
            <div className="w-full md:w-1/3">
              <div className="bg-gray-200 h-64 w-full rounded-md"></div>
            </div>
            <div className="w-full md:w-2/3">
              <h1 className="text-3xl font-bold mb-4">{person.name}</h1>
              <p className="text-lg mb-4">{person.lifespan}</p>
              <p className="mb-6">{person.shortDescription}</p>
            </div>
          </div>

          <div className="mb-8">
            <h2 className="text-2xl font-semibold mb-4">Life Experiences</h2>
            <ul className="space-y-4">
              {person.experiences.map((exp, i) => (
                <li key={i} className="border-l-4 border-gray-300 pl-4 py-1">
                  <h3 className="font-medium">{exp.year}: {exp.title}</h3>
                  <p>{exp.description}</p>
                </li>
              ))}
            </ul>
          </div>

          <div className="mb-8">
            <h2 className="text-2xl font-semibold mb-4">Achievements</h2>
            <ul className="list-disc pl-6 space-y-2">
              {person.achievements.map((ach, i) => (
                <li key={i}>{ach}</li>
              ))}
            </ul>
          </div>

          {person.honors.length > 0 && (
            <div>
              <h2 className="text-2xl font-semibold mb-4">Honors</h2>
              <ul className="list-disc pl-6 space-y-2">
                {person.honors.map((honor, i) => (
                  <li key={i}>{honor}</li>
                ))}
              </ul>
            </div>
          )}
        </div>
      </div>
    </div>
  )
}
