import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import ActivityLog from './pages/ActivityLog'
import Leaderboard from './pages/Leaderboard'
import Diary from './pages/Diary'
import Stats from './pages/Stats'
import Navbar from './components/Navbar'

function App() {
  return (
    <Router>
      <div className="app" style={{ backgroundColor: 'white', minHeight: '100vh' }}>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/log" element={<ActivityLog />} />
          <Route path="/leaderboard" element={<Leaderboard />} />
          <Route path="/diary" element={<Diary />} />
          <Route path="/stats" element={<Stats />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App
