import { useState } from 'react'
import { format } from 'date-fns'

export default function Diary() {
  const [entries, setEntries] = useState([])
  const [entry, setEntry] = useState('')
  const [date, setDate] = useState(format(new Date(), 'yyyy-MM-dd'))

  const handleSubmit = (e) => {
    e.preventDefault()
    setEntries([...entries, { date, entry }])
    setEntry('')
    setDate(format(new Date(), 'yyyy-MM-dd'))
  }

  return (
    <div style={{ padding: '16px' }}>
      <h1 style={{ color: 'navy' }}>Fitness Diary</h1>
      <form onSubmit={handleSubmit} className="card">
        <div>
          <label>Date:</label>
          <input 
            type="date" 
            value={date}
            onChange={(e) => setDate(e.target.value)}
          />
        </div>
        <div>
          <label>Entry:</label>
          <textarea 
            value={entry}
            onChange={(e) => setEntry(e.target.value)}
            style={{ width: '100%', minHeight: '100px', padding: '8px' }}
          />
        </div>
        <button type="submit">Save Entry</button>
      </form>

      <div className="card">
        <h2>Your Diary Entries</h2>
        {entries.length === 0 ? (
          <p>No diary entries yet</p>
        ) : (
          <div>
            {entries.map((item, index) => (
              <div key={index} style={{ marginBottom: '16px' }}>
                <h3>{item.date}</h3>
                <p>{item.entry}</p>
              </div>
            ))}
          </div>
        )}
      </div>
    </div>
  )
}
