export default function Leaderboard() {
  const leaderboardData = [
    { name: 'Alice', points: 1250 },
    { name: 'Bob', points: 1100 },
    { name: 'Charlie', points: 950 },
    { name: 'Diana', points: 800 },
    { name: 'Eve', points: 750 }
  ]

  return (
    <div style={{ padding: '16px' }}>
      <h1 style={{ color: 'navy' }}>Fitness Leaderboard</h1>
      <div className="card">
        <table style={{ width: '100%', borderCollapse: 'collapse' }}>
          <thead>
            <tr>
              <th style={{ textAlign: 'left', padding: '8px', borderBottom: '1px solid white' }}>Rank</th>
              <th style={{ textAlign: 'left', padding: '8px', borderBottom: '1px solid white' }}>Name</th>
              <th style={{ textAlign: 'left', padding: '8px', borderBottom: '1px solid white' }}>Points</th>
            </tr>
          </thead>
          <tbody>
            {leaderboardData.map((user, index) => (
              <tr key={index}>
                <td style={{ padding: '8px', borderBottom: '1px solid white' }}>{index + 1}</td>
                <td style={{ padding: '8px', borderBottom: '1px solid white' }}>{user.name}</td>
                <td style={{ padding: '8px', borderBottom: '1px solid white' }}>{user.points}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  )
}
