import { Bar } from 'react-chartjs-2'
import { Chart as ChartJS } from 'chart.js/auto'

export default function Stats() {
  const data = {
    labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
    datasets: [
      {
        label: 'Workout Minutes',
        data: [30, 45, 60, 30, 75, 90, 45],
        backgroundColor: 'navy'
      }
    ]
  }

  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: 'top',
      },
      title: {
        display: true,
        text: 'Weekly Activity',
      },
    },
  }

  return (
    <div style={{ padding: '16px' }}>
      <h1 style={{ color: 'navy' }}>Fitness Statistics</h1>
      <div className="card">
        <h2>Weekly Summary</h2>
        <div style={{ height: '400px' }}>
          <Bar data={data} options={options} />
        </div>
      </div>
      <div className="card">
        <h2>Monthly Overview</h2>
        <p>Total workouts: 15</p>
        <p>Total minutes: 675</p>
        <p>Average per workout: 45 mins</p>
      </div>
    </div>
  )
}
