import { useState } from 'react'
import { evaluate } from 'mathjs'
import './App.css'

export default function App() {
  const [expression, setExpression] = useState('')
  const [result, setResult] = useState('')
  const [calcType, setCalcType] = useState('basic')

  const handleCalculate = () => {
    try {
      const res = evaluate(expression)
      setResult(res.toString())
    } catch (error) {
      setResult('Error: Invalid expression')
    }
  }

  return (
    <div className="app">
      <h1>Math Calculator</h1>
      <div className="calculator">
        <div className="input-group">
          <select 
            value={calcType} 
            onChange={(e) => setCalcType(e.target.value)}
            className="calc-type"
          >
            <option value="basic">Basic Arithmetic</option>
            <option value="advanced">Advanced Functions</option>
          </select>
          
          <input
            type="text"
            value={expression}
            onChange={(e) => setExpression(e.target.value)}
            placeholder="Enter math expression (e.g., 2+3*4)"
            className="expression-input"
          />
          
          <button onClick={handleCalculate} className="calculate-btn">
            Calculate
          </button>
        </div>
        
        <div className="result-display">
          {result && <div className="result">Result: {result}</div>}
        </div>
      </div>
    </div>
  )
}
