import { useState } from 'react'
import { DndProvider } from 'react-dnd'
import { HTML5Backend } from 'react-dnd-html5-backend'
import Toolbar from './components/Toolbar'
import Canvas from './components/Canvas'
import Sidebar from './components/Sidebar'
import './App.css'

function App() {
  const [diagramType, setDiagramType] = useState('flowchart')
  const [elements, setElements] = useState([])
  const [selectedElement, setSelectedElement] = useState(null)

  const addElement = (element) => {
    setElements([...elements, element])
  }

  const removeElement = (id) => {
    setElements(elements.filter(el => el.id !== id))
    if (selectedElement?.id === id) {
      setSelectedElement(null)
    }
  }

  const updateElement = (id, updates) => {
    setElements(elements.map(el => 
      el.id === id ? { ...el, ...updates } : el
    ))
  }

  return (
    <DndProvider backend={HTML5Backend}>
      <div className="app">
        <Toolbar 
          diagramType={diagramType}
          setDiagramType={setDiagramType}
        />
        <div className="workspace">
          <Sidebar 
            diagramType={diagramType}
            addElement={addElement}
          />
          <Canvas 
            elements={elements}
            selectedElement={selectedElement}
            setSelectedElement={setSelectedElement}
            removeElement={removeElement}
            updateElement={updateElement}
          />
        </div>
      </div>
    </DndProvider>
  )
}

export default App
