import { useDrop } from 'react-dnd'

export default function Canvas({ 
  elements, 
  selectedElement, 
  setSelectedElement, 
  removeElement, 
  updateElement 
}) {
  const [, drop] = useDrop(() => ({
    accept: 'element',
    drop: (item, monitor) => {
      const offset = monitor.getClientOffset()
      return { x: offset?.x || 0, y: offset?.y || 0 }
    },
  }))

  return (
    <div 
      ref={drop} 
      className="canvas" 
      style={{
        flex: 1,
        position: 'relative',
        backgroundColor: 'ghostwhite',
        overflow: 'auto'
      }}
    >
      {elements.map((element) => (
        <div
          key={element.id}
          onClick={() => setSelectedElement(element)}
          style={{
            position: 'absolute',
            left: element.x,
            top: element.y,
            width: element.width,
            height: element.height,
            backgroundColor: selectedElement?.id === element.id ? 'lightsteelblue' : 'slategray',
            color: 'white',
            padding: '10px',
            borderRadius: '4px',
            cursor: 'move',
            border: selectedElement?.id === element.id ? '2px solid steelblue' : 'none'
          }}
        >
          {element.text}
          {selectedElement?.id === element.id && (
            <button 
              onClick={(e) => {
                e.stopPropagation()
                removeElement(element.id)
              }}
              style={{
                position: 'absolute',
                top: '-10px',
                right: '-10px',
                background: 'red',
                color: 'white',
                border: 'none',
                borderRadius: '50%',
                width: '20px',
                height: '20px',
                cursor: 'pointer'
              }}
            >
              ×
            </button>
          )}
        </div>
      ))}
    </div>
  )
}
