import { useDrag } from 'react-dnd'

const elementTypes = {
  flowchart: ['Process', 'Decision', 'Terminator', 'Data'],
  orgchart: ['Employee', 'Manager', 'Department', 'Position'],
  mindmap: ['Idea', 'Topic', 'SubTopic', 'Connection']
}

export default function Sidebar({ diagramType, addElement }) {
  const renderElement = (type) => {
    const [{ isDragging }, drag] = useDrag(() => ({
      type: 'element',
      item: { type },
      end: (item, monitor) => {
        const dropResult = monitor.getDropResult()
        if (item && dropResult) {
          addElement({
            id: Date.now().toString(),
            type: item.type,
            x: dropResult.x,
            y: dropResult.y,
            text: `${item.type} ${Math.floor(Math.random() * 100)}`,
            width: 100,
            height: 60
          })
        }
      },
      collect: (monitor) => ({
        isDragging: monitor.isDragging(),
      }),
    }))

    return (
      <div
        ref={drag}
        className="sidebar-element"
        style={{
          opacity: isDragging ? 0.5 : 1,
          backgroundColor: 'slategray',
          color: 'white',
          padding: '10px',
          margin: '5px',
          borderRadius: '4px',
          cursor: 'move'
        }}
      >
        {type}
      </div>
    )
  }

  return (
    <div className="sidebar" style={{
      width: '200px',
      backgroundColor: 'ghostwhite',
      padding: '10px',
      borderRight: '1px solid slategray'
    }}>
      <h3 style={{ marginBottom: '10px', color: 'slategray' }}>Elements</h3>
      {elementTypes[diagramType].map((type) => (
        <div key={type}>{renderElement(type)}</div>
      ))}
    </div>
  )
}
