import { Routes, Route } from 'react-router-dom'
import CaseList from './components/CaseList'
import CaseDetail from './components/CaseDetail'
import NewCase from './components/NewCase'
import TimeTracker from './components/TimeTracker'
import ExpenseSheet from './components/ExpenseSheet'
import AssignmentSheet from './components/AssignmentSheet'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  return (
    <div className="app">
      <Navbar />
      <div className="content">
        <Routes>
          <Route path="/" element={<CaseList />} />
          <Route path="/cases/:id" element={<CaseDetail />} />
          <Route path="/new-case" element={<NewCase />} />
          <Route path="/time-tracker" element={<TimeTracker />} />
          <Route path="/expense-sheet" element={<ExpenseSheet />} />
          <Route path="/assignment-sheet" element={<AssignmentSheet />} />
        </Routes>
      </div>
    </div>
  )
}

export default App
