import { useState, useEffect } from 'react'
import { Link } from 'react-router-dom'
import './CaseList.css'

function CaseList() {
  const [cases, setCases] = useState([])

  useEffect(() => {
    // In a real app, this would fetch from an API
    const mockCases = [
      { id: '1', title: 'Missing Jewelry', status: 'Active', client: 'John Smith' },
      { id: '2', title: 'Corporate Espionage', status: 'Active', client: 'Acme Corp' },
      { id: '3', title: 'Infidelity Case', status: 'Closed', client: 'Jane Doe' }
    ]
    setCases(mockCases)
  }, [])

  return (
    <div className="case-list">
      <h2>Case List</h2>
      <div className="cases">
        {cases.map((caseItem) => (
          <div key={caseItem.id} className="case-card">
            <h3>{caseItem.title}</h3>
            <p>Client: {caseItem.client}</p>
            <p>Status: {caseItem.status}</p>
            <Link to={`/cases/${caseItem.id}`}>View Details</Link>
          </div>
        ))}
      </div>
    </div>
  )
}

export default CaseList
