const express = require('express')
const { createClient } = require('libsql')
const cors = require('cors')

const app = express()
app.use(cors())
app.use(express.json())

const db = createClient({
  url: 'file:risk_assessment.db'
})

// Initialize database
async function initDB() {
  await db.execute(`
    CREATE TABLE IF NOT EXISTS risks (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      category TEXT NOT NULL,
      name TEXT NOT NULL,
      likelihood INTEGER,
      impact INTEGER,
      description TEXT,
      mitigation TEXT
    )
  `)

  await db.execute(`
    CREATE TABLE IF NOT EXISTS users (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      email TEXT UNIQUE NOT NULL,
      is_subscribed BOOLEAN DEFAULT FALSE
    )
  `)
}

// API endpoints
app.get('/api/risks', async (req, res) => {
  const result = await db.execute('SELECT * FROM risks')
  res.json(result.rows)
})

app.post('/api/assessments', async (req, res) => {
  const { risks } = req.body
  // Process assessment and generate report data
  res.json({ success: true, data: risks })
})

app.post('/api/subscribe', async (req, res) => {
  const { email } = req.body
  try {
    await db.execute({
      sql: 'INSERT INTO users (email, is_subscribed) VALUES (?, ?)',
      args: [email, true]
    })
    res.json({ success: true })
  } catch (err) {
    res.status(400).json({ error: 'Subscription failed' })
  }
})

initDB().then(() => {
  app.listen(3001, () => {
    console.log('Server running on port 3001')
  })
})
