import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { useState, useEffect } from 'react'
import Dashboard from './components/Dashboard'
import RiskAssessment from './components/RiskAssessment'
import Reports from './components/Reports'
import Subscription from './components/Subscription'
import Navbar from './components/Navbar'
import './App.scss'

function App() {
  const [isSubscribed, setIsSubscribed] = useState(false)

  return (
    <BrowserRouter>
      <div className="app-container">
        <Navbar isSubscribed={isSubscribed} />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/assess" element={
            isSubscribed ? <RiskAssessment /> : <Subscription />
          } />
          <Route path="/reports" element={<Reports />} />
          <Route path="/subscribe" element={
            <Subscription setIsSubscribed={setIsSubscribed} />
          } />
        </Routes>
      </div>
    </BrowserRouter>
  )
}

export default App
