import { useState, useEffect } from 'react'
import { Bar, Pie } from 'react-chartjs-2'
import { Chart as ChartJS } from 'chart.js/auto'

export default function RiskAssessment() {
  const [risks, setRisks] = useState([])
  const [selectedRisks, setSelectedRisks] = useState([])
  const [reportData, setReportData] = useState(null)

  useEffect(() => {
    fetch('http://localhost:3001/api/risks')
      .then(res => res.json())
      .then(data => setRisks(data))
  }, [])

  const handleRiskSelect = (risk) => {
    setSelectedRisks([...selectedRisks, risk])
  }

  const generateReport = () => {
    fetch('http://localhost:3001/api/assessments', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ risks: selectedRisks })
    })
    .then(res => res.json())
    .then(data => setReportData(data.data))
  }

  const riskChartData = {
    labels: selectedRisks.map(r => r.name),
    datasets: [{
      label: 'Risk Score',
      data: selectedRisks.map(r => r.likelihood * r.impact),
      backgroundColor: 'steelblue'
    }]
  }

  return (
    <div className="risk-assessment">
      <h2>Risk Assessment</h2>
      <div className="risk-selection">
        <h3>Available Risks</h3>
        <ul>
          {risks.map(risk => (
            <li key={risk.id} onClick={() => handleRiskSelect(risk)}>
              {risk.name} (L: {risk.likelihood}, I: {risk.impact})
            </li>
          ))}
        </ul>
      </div>

      <div className="selected-risks">
        <h3>Selected Risks</h3>
        {selectedRisks.length > 0 && (
          <button onClick={generateReport}>Generate Report</button>
        )}
        <ul>
          {selectedRisks.map((risk, i) => (
            <li key={i}>
              {risk.name} - Score: {risk.likelihood * risk.impact}
            </li>
          ))}
        </ul>
      </div>

      {reportData && (
        <div className="risk-report">
          <h3>Risk Analysis</h3>
          <div className="charts">
            <div className="chart-container">
              <Bar data={riskChartData} />
            </div>
            <div className="chart-container">
              <Pie data={riskChartData} />
            </div>
          </div>
        </div>
      )}
    </div>
  )
}
