import { useParams } from 'react-router-dom'

const articles = {
  1: {
    title: 'Advances in Cancer Research',
    author: 'Dr. Smith',
    date: '2024-01-15',
    content: 'Lorem ipsum dolor sit amet...',
    pdfUrl: '#'
  },
  2: {
    title: 'New Approaches to Heart Disease',
    author: 'Dr. Johnson',
    date: '2024-02-20',
    content: 'Lorem ipsum dolor sit amet...',
    pdfUrl: '#'
  },
  3: {
    title: 'Breakthrough in Neurological Disorders',
    author: 'Dr. Williams',
    date: '2024-03-10',
    content: 'Lorem ipsum dolor sit amet...',
    pdfUrl: '#'
  }
}

export default function ArticleDetail() {
  const { id } = useParams()
  const article = articles[id]

  if (!article) return <div>Article not found</div>

  return (
    <div style={{ maxWidth: '1200px', margin: '40px auto', padding: '0 20px' }}>
      <h1 style={{ color: 'crimson', marginBottom: '10px' }}>{article.title}</h1>
      <p style={{ marginBottom: '30px' }}>By {article.author} | Published: {article.date}</p>
      
      <div style={{ 
        backgroundColor: 'white', 
        padding: '30px', 
        borderRadius: '8px',
        boxShadow: '0 2px 5px rgba(0,0,0,0.1)',
        marginBottom: '30px'
      }}>
        <p style={{ lineHeight: '1.6', marginBottom: '20px' }}>{article.content}</p>
        <a href={article.pdfUrl} download>
          <button>Download PDF</button>
        </a>
      </div>
    </div>
  )
}
