import { useState } from 'react'
import { Link } from 'react-router-dom'

const articles = [
  { id: 1, title: 'Advances in Cancer Research', author: 'Dr. Smith', date: '2024-01-15' },
  { id: 2, title: 'New Approaches to Heart Disease', author: 'Dr. Johnson', date: '2024-02-20' },
  { id: 3, title: 'Breakthrough in Neurological Disorders', author: 'Dr. Williams', date: '2024-03-10' }
]

export default function SearchResults() {
  const [searchTerm, setSearchTerm] = useState('')
  
  const filteredArticles = articles.filter(article => 
    article.title.toLowerCase().includes(searchTerm.toLowerCase()) ||
    article.author.toLowerCase().includes(searchTerm.toLowerCase())
  )

  return (
    <div style={{ maxWidth: '1200px', margin: '40px auto', padding: '0 20px' }}>
      <h1 style={{ color: 'crimson', marginBottom: '30px' }}>Search Articles</h1>
      
      <div style={{ marginBottom: '30px' }}>
        <input 
          type="text" 
          placeholder="Search by title or author..." 
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
          style={{ padding: '10px', width: '100%', maxWidth: '500px' }}
        />
      </div>
      
      <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
        {filteredArticles.map(article => (
          <div key={article.id} style={{ 
            backgroundColor: 'white', 
            padding: '20px', 
            borderRadius: '8px',
            boxShadow: '0 2px 5px rgba(0,0,0,0.1)'
          }}>
            <h3 style={{ color: 'crimson' }}>{article.title}</h3>
            <p>By {article.author} | Published: {article.date}</p>
            <div style={{ marginTop: '15px' }}>
              <Link to={`/articles/${article.id}`}>
                <button>Read Article</button>
              </Link>
            </div>
          </div>
        ))}
        
        {filteredArticles.length === 0 && (
          <p>No articles found matching your search.</p>
        )}
      </div>
    </div>
  )
}
