import { useState, useEffect } from 'react'
import { Link } from 'react-router-dom'
import '../App.css'

const SpeciesList = () => {
  const [species, setSpecies] = useState([])
  const [searchTerm, setSearchTerm] = useState('')
  const [filters, setFilters] = useState({
    kingdom: '',
    conservationStatus: ''
  })

  useEffect(() => {
    // Mock data - in a real app, this would come from an API
    const mockSpecies = [
      { id: 1, name: 'Panthera leo', commonName: 'Lion', kingdom: 'Animalia', conservationStatus: 'Vulnerable' },
      { id: 2, name: 'Quercus robur', commonName: 'English Oak', kingdom: 'Plantae', conservationStatus: 'Least Concern' },
      { id: 3, name: 'Agaricus bisporus', commonName: 'Button Mushroom', kingdom: 'Fungi', conservationStatus: 'Least Concern' },
      { id: 4, name: 'Escherichia coli', commonName: 'E. coli', kingdom: 'Bacteria', conservationStatus: 'Not Evaluated' },
      { id: 5, name: 'Panthera tigris', commonName: 'Tiger', kingdom: 'Animalia', conservationStatus: 'Endangered' },
    ]
    setSpecies(mockSpecies)
  }, [])

  const filteredSpecies = species.filter(specie => {
    const matchesSearch = specie.name.toLowerCase().includes(searchTerm.toLowerCase()) || 
                         specie.commonName.toLowerCase().includes(searchTerm.toLowerCase())
    const matchesKingdom = !filters.kingdom || specie.kingdom === filters.kingdom
    const matchesStatus = !filters.conservationStatus || specie.conservationStatus === filters.conservationStatus
    
    return matchesSearch && matchesKingdom && matchesStatus
  })

  const kingdoms = [...new Set(species.map(s => s.kingdom))]
  const statuses = [...new Set(species.map(s => s.conservationStatus))]

  return (
    <div className="container">
      <h1 style={{ color: 'maroon', marginBottom: '20px' }}>Species Database</h1>
      
      <div style={{ marginBottom: '30px' }}>
        <input
          type="text"
          placeholder="Search species..."
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
          style={{
            padding: '10px',
            width: '100%',
            maxWidth: '500px',
            marginBottom: '15px',
            border: '1px solid maroon'
          }}
        />
        
        <div style={{ display: 'flex', gap: '20px', marginBottom: '15px' }}>
          <div>
            <label style={{ display: 'block', marginBottom: '5px', color: 'maroon' }}>Kingdom:</label>
            <select
              value={filters.kingdom}
              onChange={(e) => setFilters({...filters, kingdom: e.target.value})}
              style={{ padding: '8px', border: '1px solid maroon' }}
            >
              <option value="">All Kingdoms</option>
              {kingdoms.map(kingdom => (
                <option key={kingdom} value={kingdom}>{kingdom}</option>
              ))}
            </select>
          </div>
          
          <div>
            <label style={{ display: 'block', marginBottom: '5px', color: 'maroon' }}>Conservation Status:</label>
            <select
              value={filters.conservationStatus}
              onChange={(e) => setFilters({...filters, conservationStatus: e.target.value})}
              style={{ padding: '8px', border: '1px solid maroon' }}
            >
              <option value="">All Statuses</option>
              {statuses.map(status => (
                <option key={status} value={status}>{status}</option>
              ))}
            </select>
          </div>
        </div>
      </div>
      
      <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fill, minmax(300px, 1fr))', gap: '20px' }}>
        {filteredSpecies.map(specie => (
          <div key={specie.id} style={{
            border: '1px solid maroon',
            borderRadius: '5px',
            padding: '15px',
            backgroundColor: 'white'
          }}>
            <h3 style={{ color: 'maroon', marginBottom: '10px' }}>{specie.commonName}</h3>
            <p><strong>Scientific Name:</strong> {specie.name}</p>
            <p><strong>Kingdom:</strong> {specie.kingdom}</p>
            <p><strong>Status:</strong> {specie.conservationStatus}</p>
            <Link 
              to={`/species/${specie.id}`} 
              style={{
                display: 'inline-block',
                marginTop: '10px',
                color: 'maroon',
                textDecoration: 'none',
                fontWeight: 'bold'
              }}
            >
              View Details →
            </Link>
          </div>
        ))}
      </div>
    </div>
  )
}

export default SpeciesList
