import { useContext } from 'react'
import { ArticlesContext } from '../context/ArticlesContext'
import { AuthContext } from '../context/AuthContext'

function ProfilePage() {
  const { user } = useContext(AuthContext)
  const { articles, favorites } = useContext(ArticlesContext)

  const favoriteArticles = articles.filter(article => favorites.includes(article.id))

  return (
    <div>
      <h2>Your Profile</h2>
      <div style={{ 
        backgroundColor: 'oldlace',
        padding: '20px',
        borderRadius: '8px',
        marginBottom: '20px'
      }}>
        <h3>Account Information</h3>
        <p><strong>Email:</strong> {user?.email || 'Not available'}</p>
      </div>

      <div style={{ 
        backgroundColor: 'oldlace',
        padding: '20px',
        borderRadius: '8px'
      }}>
        <h3>Your Favorites ({favoriteArticles.length})</h3>
        {favoriteArticles.length > 0 ? (
          <div style={{ display: 'grid', gap: '15px' }}>
            {favoriteArticles.map(article => (
              <div key={article.id} style={{ 
                padding: '15px',
                borderBottom: '1px solid #ddd'
              }}>
                <h4>{article.title}</h4>
                <p>{article.content.substring(0, 100)}...</p>
              </div>
            ))}
          </div>
        ) : (
          <p>You haven't favorited any articles yet.</p>
        )}
      </div>
    </div>
  )
}

export default ProfilePage
