import './UserRecords.css'

function UserRecords({ records }) {
  return (
    <div className="user-records">
      <h2>Your Winning History</h2>
      
      {records.length === 0 ? (
        <p className="no-records">You haven't won anything yet. Spin the wheel to get started!</p>
      ) : (
        <table>
          <thead>
            <tr>
              <th>Date</th>
              <th>Prize</th>
            </tr>
          </thead>
          <tbody>
            {records.map(record => (
              <tr key={record.id}>
                <td>{record.date}</td>
                <td>{record.prize}</td>
              </tr>
            ))}
          </tbody>
        </table>
      )}
    </div>
  )
}

export default UserRecords
