import { Box, Typography, Button } from '@mui/material'
import { Link } from 'react-router-dom'

export default function Home() {
  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h3" gutterBottom>
        Welcome to SkillShare
      </Typography>
      <Typography variant="body1" paragraph>
        Connect with professionals and showcase your skills
      </Typography>
      <Box sx={{ mt: 4 }}>
        <Button
          component={Link}
          to="/profile"
          variant="contained"
          sx={{ mr: 2 }}
        >
          Create Profile
        </Button>
        <Button component={Link} to="/search" variant="contained">
          Find Professionals
        </Button>
      </Box>
    </Box>
  )
}
