import { useState } from 'react'
import { Box, Typography, TextField, Button, Chip, Stack } from '@mui/material'

export default function Profile() {
  const [profile, setProfile] = useState({
    name: '',
    bio: '',
    skills: [],
    certifications: []
  })
  const [newSkill, setNewSkill] = useState('')
  const [newCert, setNewCert] = useState('')

  const handleAddSkill = () => {
    if (newSkill) {
      setProfile({
        ...profile,
        skills: [...profile.skills, newSkill]
      })
      setNewSkill('')
    }
  }

  const handleAddCert = () => {
    if (newCert) {
      setProfile({
        ...profile,
        certifications: [...profile.certifications, newCert]
      })
      setNewCert('')
    }
  }

  const handleRemoveSkill = (skillToRemove) => {
    setProfile({
      ...profile,
      skills: profile.skills.filter(skill => skill !== skillToRemove)
    })
  }

  const handleRemoveCert = (certToRemove) => {
    setProfile({
      ...profile,
      certifications: profile.certifications.filter(cert => cert !== certToRemove)
    })
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>
        Your Profile
      </Typography>
      <Box component="form" sx={{ mt: 3 }}>
        <TextField
          label="Name"
          fullWidth
          margin="normal"
          value={profile.name}
          onChange={(e) => setProfile({...profile, name: e.target.value})}
        />
        <TextField
          label="Bio"
          fullWidth
          multiline
          rows={4}
          margin="normal"
          value={profile.bio}
          onChange={(e) => setProfile({...profile, bio: e.target.value})}
        />
        
        <Typography variant="h6" sx={{ mt: 3 }}>Skills</Typography>
        <Stack direction="row" spacing={1} sx={{ my: 2 }}>
          {profile.skills.map((skill) => (
            <Chip
              key={skill}
              label={skill}
              onDelete={() => handleRemoveSkill(skill)}
            />
          ))}
        </Stack>
        <Box sx={{ display: 'flex', gap: 2 }}>
          <TextField
            label="Add Skill"
            value={newSkill}
            onChange={(e) => setNewSkill(e.target.value)}
          />
          <Button variant="contained" onClick={handleAddSkill}>
            Add
          </Button>
        </Box>

        <Typography variant="h6" sx={{ mt: 3 }}>Certifications</Typography>
        <Stack direction="row" spacing={1} sx={{ my: 2 }}>
          {profile.certifications.map((cert) => (
            <Chip
              key={cert}
              label={cert}
              onDelete={() => handleRemoveCert(cert)}
            />
          ))}
        </Stack>
        <Box sx={{ display: 'flex', gap: 2 }}>
          <TextField
            label="Add Certification"
            value={newCert}
            onChange={(e) => setNewCert(e.target.value)}
          />
          <Button variant="contained" onClick={handleAddCert}>
            Add
          </Button>
        </Box>

        <Button
          variant="contained"
          sx={{ mt: 4 }}
          onClick={() => console.log('Profile saved:', profile)}
        >
          Save Profile
        </Button>
      </Box>
    </Box>
  )
}
