import { useState, useEffect } from 'react'
import { Box, Typography, TextField, Button, Card, CardContent, Chip } from '@mui/material'

export default function Search() {
  const [searchTerm, setSearchTerm] = useState('')
  const [results, setResults] = useState([])

  useEffect(() => {
    // Mock data - in a real app, this would come from an API
    const mockProfiles = [
      {
        id: 1,
        name: 'Jane Doe',
        bio: 'Web developer with 5 years experience',
        skills: ['JavaScript', 'React', 'Node.js'],
        certifications: ['AWS Certified', 'React Professional']
      },
      {
        id: 2,
        name: 'John Smith',
        bio: 'DevOps engineer specializing in cloud infrastructure',
        skills: ['AWS', 'Docker', 'Kubernetes'],
        certifications: ['AWS Solutions Architect', 'CKAD']
      }
    ]
    setResults(mockProfiles)
  }, [])

  const handleSearch = () => {
    // In a real app, this would call an API with the search term
    console.log('Searching for:', searchTerm)
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>
        Find Professionals
      </Typography>
      <Box sx={{ display: 'flex', gap: 2, mb: 4 }}>
        <TextField
          label="Search by skill or certification"
          fullWidth
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
        <Button variant="contained" onClick={handleSearch}>
          Search
        </Button>
      </Box>

      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 3 }}>
        {results.map((profile) => (
          <Card key={profile.id}>
            <CardContent>
              <Typography variant="h5">{profile.name}</Typography>
              <Typography variant="body1" sx={{ my: 2 }}>
                {profile.bio}
              </Typography>
              <Box sx={{ mb: 2 }}>
                <Typography variant="subtitle1">Skills:</Typography>
                <Box sx={{ display: 'flex', gap: 1, flexWrap: 'wrap', mt: 1 }}>
                  {profile.skills.map((skill) => (
                    <Chip key={skill} label={skill} />
                  ))}
                </Box>
              </Box>
              <Box>
                <Typography variant="subtitle1">Certifications:</Typography>
                <Box sx={{ display: 'flex', gap: 1, flexWrap: 'wrap', mt: 1 }}>
                  {profile.certifications.map((cert) => (
                    <Chip key={cert} label={cert} color="primary" />
                  ))}
                </Box>
              </Box>
              <Button
                variant="contained"
                sx={{ mt: 2 }}
                onClick={() => console.log('Contact:', profile.name)}
              >
                Contact
              </Button>
            </CardContent>
          </Card>
        ))}
      </Box>
    </Box>
  )
}
