const API_BASE = '/api'

export const getProfiles = async (searchTerm = '') => {
  const response = await fetch(`${API_BASE}/profiles?search=${encodeURIComponent(searchTerm)}`)
  if (!response.ok) {
    throw new Error('Failed to fetch profiles')
  }
  return await response.json()
}

export const createProfile = async (profileData) => {
  const response = await fetch(`${API_BASE}/profiles`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify(profileData)
  })
  if (!response.ok) {
    throw new Error('Failed to create profile')
  }
  return await response.json()
}
