import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Gallery from './pages/Gallery'
import Ideas from './pages/Ideas'
import Discussions from './pages/Discussions'
import Navbar from './components/Navbar'
import Footer from './components/Footer'

function App() {
  return (
    <Router>
      <div className="app">
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/gallery" element={<Gallery />} />
          <Route path="/ideas" element={<Ideas />} />
          <Route path="/discussions" element={<Discussions />} />
        </Routes>
        <Footer />
      </div>
    </Router>
  )
}

export default App
