import { useState } from 'react'
import '../styles/Discussions.css'

const Discussions = () => {
  const [discussions] = useState([
    { id: 1, title: 'What inspires your creativity?', author: 'Dana', replies: 12 },
    { id: 2, title: 'Dream interpretation corner', author: 'Evan', replies: 8 },
    { id: 3, title: 'Collaboration ideas', author: 'Fiona', replies: 5 }
  ])

  return (
    <div className="discussions">
      <h2>Community Discussions</h2>
      <div className="discussion-list">
        {discussions.map(discussion => (
          <div key={discussion.id} className="discussion-card">
            <h3>{discussion.title}</h3>
            <p>Started by {discussion.author}</p>
            <p>{discussion.replies} replies</p>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Discussions
