import { useState, useEffect } from 'react'
import AnimalDashboard from './components/AnimalDashboard'
import AlertSettings from './components/AlertSettings'
import DetectionHistory from './components/DetectionHistory'
import './App.css'

function App() {
  const [detections, setDetections] = useState([])
  const [alerts, setAlerts] = useState([])

  return (
    <div className="app">
      <header style={{ backgroundColor: 'firebrick' }}>
        <h1>Wild Animal Spotter</h1>
      </header>
      <main>
        <AnimalDashboard />
        <div className="content">
          <AlertSettings alerts={alerts} setAlerts={setAlerts} />
          <DetectionHistory detections={detections} />
        </div>
      </main>
    </div>
  )
}

export default App
