import { useState } from 'react'
import { mockDownloads } from '../data/mockData'

export default function Downloads() {
  return (
    <div className="container">
      <h1>Your Downloads</h1>
      <div className="grid">
        {mockDownloads.map(item => (
          <div key={item.id} className="card">
            <h3>{item.name}</h3>
            {item.type === 'ringtone' ? (
              <audio controls src={item.url} />
            ) : (
              <img src={item.url} alt={item.name} />
            )}
            <p>Downloaded on: {item.date}</p>
          </div>
        ))}
      </div>
    </div>
  )
}
