import express from 'express'
import cors from 'cors'

const app = express()
app.use(cors())
app.use(express.json())

// Enhanced mock database
const campsites = [
  { id: 1, name: 'Alpine Meadows', country: 'Switzerland', city: 'Interlaken', rating: 4.5, price: 35, facilities: ['WiFi', 'Showers', 'Laundry'] },
  { id: 2, name: 'Loire Valley Camp', country: 'France', city: 'Tours', rating: 4.2, price: 28, facilities: ['Pool', 'Restaurant'] },
  { id: 3, name: 'Nordic Wilderness', country: 'Norway', city: 'Oslo', rating: 4.7, price: 42, facilities: ['Sauna', 'Fishing'] }
]

const attractions = [
  { id: 1, name: 'Eiffel Tower', country: 'France', city: 'Paris', type: 'Landmark', entryFee: 25 },
  { id: 2, name: 'Plitvice Lakes', country: 'Croatia', city: 'Plitvice', type: 'National Park', entryFee: 15 },
  { id: 3, name: 'Sagrada Familia', country: 'Spain', city: 'Barcelona', type: 'Landmark', entryFee: 30 }
]

// Bookings storage
let bookings = []
let reviews = []

// Enhanced API endpoints
app.get('/api/campsites', (req, res) => {
  const { q } = req.query
  let filtered = campsites
  
  if (q) {
    filtered = campsites.filter(item => 
      item.name.toLowerCase().includes(q.toLowerCase()) ||
      item.city.toLowerCase().includes(q.toLowerCase()) ||
      item.country.toLowerCase().includes(q.toLowerCase())
    )
  }
  
  res.json(filtered)
})

app.get('/api/attractions', (req, res) => {
  const { q } = req.query
  let filtered = attractions
  
  if (q) {
    filtered = attractions.filter(item => 
      item.name.toLowerCase().includes(q.toLowerCase()) ||
      item.city.toLowerCase().includes(q.toLowerCase()) ||
      item.country.toLowerCase().includes(q.toLowerCase())
    )
  }
  
  res.json(filtered)
})

app.post('/api/bookings', (req, res) => {
  const newBooking = {
    id: bookings.length + 1,
    ...req.body,
    createdAt: new Date().toISOString()
  }
  bookings.push(newBooking)
  res.status(201).json({ message: 'Booking successful', booking: newBooking })
})

app.post('/api/reviews', (req, res) => {
  const newReview = {
    id: reviews.length + 1,
    ...req.body,
    createdAt: new Date().toISOString()
  }
  reviews.push(newReview)
  res.status(201).json({ message: 'Review submitted', review: newReview })
})

// New endpoints for getting bookings and reviews
app.get('/api/bookings', (req, res) => {
  res.json(bookings)
})

app.get('/api/reviews', (req, res) => {
  res.json(reviews)
})

const PORT = 3001
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})
