import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import styled from 'styled-components'
import Home from './pages/Home'
import Search from './pages/Search'
import Booking from './pages/Booking'
import Reviews from './pages/Reviews'
import Navbar from './components/Navbar'

const AppContainer = styled.div`
  background-color: #ffd6e7; /* light pink */
  min-height: 100vh;
`

function App() {
  return (
    <AppContainer>
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/search" element={<Search />} />
          <Route path="/booking" element={<Booking />} />
          <Route path="/reviews" element={<Reviews />} />
        </Routes>
      </Router>
    </AppContainer>
  )
}

export default App
