import styled from 'styled-components'
import { Link } from 'react-router-dom'

const Nav = styled.nav`
  background-color: #c71585; /* medium violet red */
  padding: 1rem;
`

const NavList = styled.ul`
  display: flex;
  list-style: none;
  gap: 2rem;
`

const NavLink = styled(Link)`
  color: white;
  text-decoration: none;
  font-weight: bold;
  &:hover {
    text-decoration: underline;
  }
`

function Navbar() {
  return (
    <Nav>
      <NavList>
        <li><NavLink to="/">Home</NavLink></li>
        <li><NavLink to="/search">Search</NavLink></li>
        <li><NavLink to="/booking">My Bookings</NavLink></li>
        <li><NavLink to="/reviews">My Reviews</NavLink></li>
      </NavList>
    </Nav>
  )
}

export default Navbar
