import { useState } from 'react'
import styled from 'styled-components'
import SearchForm from '../components/SearchForm'
import SearchResults from '../components/SearchResults'

const Container = styled.div`
  padding: 2rem;
`

function Search() {
  const [results, setResults] = useState([])

  return (
    <Container>
      <h2>Search Attractions & Campsites</h2>
      <SearchForm setResults={setResults} />
      <SearchResults results={results} />
    </Container>
  )
}

export default Search
