import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import PackageCard from '../components/PackageCard'

const packages = [
  {
    id: 1,
    title: 'Premium Golf Resort',
    location: 'Scottsdale, AZ',
    price: 2499,
    nights: 5,
    rounds: 4,
    image: '/golf1.jpg'
  },
  // Add more packages...
]

export default function Home() {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    phone: '',
    packageId: '',
    dates: '',
    players: 1
  })
  const navigate = useNavigate()

  const handleSubmit = (e) => {
    e.preventDefault()
    navigate('/booking', { state: formData })
  }

  return (
    <div className="container mx-auto px-4 py-8">
      <section className="main-component p-6 rounded-lg mb-8">
        <h1 className="text-3xl font-bold mb-4">Golf Travel Packages</h1>
        <p className="mb-6">Book your dream golf vacation with us</p>
      </section>

      <section className="grid md:grid-cols-3 gap-6 mb-8">
        {packages.map(pkg => (
          <PackageCard key={pkg.id} pkg={pkg} />
        ))}
      </section>

      <section className="main-component p-6 rounded-lg">
        <h2 className="text-2xl font-bold mb-4">Request a Quote</h2>
        <form onSubmit={handleSubmit}>
          <div className="grid md:grid-cols-2 gap-4">
            <input
              type="text"
              placeholder="Full Name"
              className="p-2 rounded border"
              required
              value={formData.name}
              onChange={(e) => setFormData({...formData, name: e.target.value})}
            />
            <input
              type="email"
              placeholder="Email"
              className="p-2 rounded border"
              required
              value={formData.email}
              onChange={(e) => setFormData({...formData, email: e.target.value})}
            />
            <input
              type="tel"
              placeholder="Phone"
              className="p-2 rounded border"
              required
              value={formData.phone}
              onChange={(e) => setFormData({...formData, phone: e.target.value})}
            />
            <select
              className="p-2 rounded border"
              required
              value={formData.packageId}
              onChange={(e) => setFormData({...formData, packageId: e.target.value})}
            >
              <option value="">Select Package</option>
              {packages.map(pkg => (
                <option key={pkg.id} value={pkg.id}>{pkg.title}</option>
              ))}
            </select>
            <input
              type="date"
              placeholder="Travel Dates"
              className="p-2 rounded border"
              required
              value={formData.dates}
              onChange={(e) => setFormData({...formData, dates: e.target.value})}
            />
            <input
              type="number"
              placeholder="Number of Players"
              min="1"
              className="p-2 rounded border"
              required
              value={formData.players}
              onChange={(e) => setFormData({...formData, players: e.target.value})}
            />
          </div>
          <button type="submit" className="btn-primary mt-4">
            Get Quote
          </button>
        </form>
      </section>
    </div>
  )
}
