import React, { useState } from 'react'
import '../styles/booking.css'

type BookingType = 'flight' | 'hotel' | 'train'

const BookingForm: React.FC = () => {
  const [bookingType, setBookingType] = useState<BookingType>('flight')
  const [formData, setFormData] = useState({
    date: '',
    destination: '',
    amount: '',
    description: ''
  })

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    console.log('Booking submitted:', { bookingType, ...formData })
    // TODO: Connect to backend
  }

  return (
    <div className="booking-form-container">
      <h2>New Travel Booking</h2>
      <div className="booking-type-selector">
        <button 
          className={bookingType === 'flight' ? 'active' : ''}
          onClick={() => setBookingType('flight')}
        >
          Flight Tickets
        </button>
        <button
          className={bookingType === 'hotel' ? 'active' : ''}
          onClick={() => setBookingType('hotel')}
        >
          Hotel Stay
        </button>
        <button
          className={bookingType === 'train' ? 'active' : ''}
          onClick={() => setBookingType('train')}
        >
          Train Tickets
        </button>
      </div>

      <form onSubmit={handleSubmit}>
        <div className="form-group">
          <label>Date:</label>
          <input
            type="date"
            value={formData.date}
            onChange={(e) => setFormData({...formData, date: e.target.value})}
            required
          />
        </div>
        <div className="form-group">
          <label>Destination:</label>
          <input
            type="text"
            value={formData.destination}
            onChange={(e) => setFormData({...formData, destination: e.target.value})}
            required
          />
        </div>
        <div className="form-group">
          <label>Amount (USD):</label>
          <input
            type="number"
            value={formData.amount}
            onChange={(e) => setFormData({...formData, amount: e.target.value})}
            required
          />
        </div>
        <div className="form-group">
          <label>Description:</label>
          <textarea
            value={formData.description}
            onChange={(e) => setFormData({...formData, description: e.target.value})}
          />
        </div>
        <button type="submit" className="submit-button">
          Submit Booking
        </button>
      </form>
    </div>
  )
}

export default BookingForm