import React from 'react'
import { Link } from 'react-router-dom'
import '../styles/main.css'

const Navbar: React.FC = () => {
  return (
    <nav className="navbar" style={{ backgroundColor: 'var(--primary-color)' }}>
      <div className="navbar-container">
        <Link to="/" className="navbar-logo">
          Travel Reimbursement
        </Link>
        <ul className="navbar-menu">
          <li className="navbar-item">
            <Link to="/" className="navbar-link">
              Home
            </Link>
          </li>
          <li className="navbar-item">
            <Link to="/bookings" className="navbar-link">
              Bookings
            </Link>
          </li>
          <li className="navbar-item">
            <Link to="/reimbursements" className="navbar-link">
              Reimbursements
            </Link>
          </li>
        </ul>
      </div>
    </nav>
  )
}

export default Navbar