import React, { useState } from 'react'
import './LeadForm.css'

const LeadForm = () => {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    phone: '',
    currentScore: '',
    desiredScore: '',
    concerns: ''
  })

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target
    setFormData(prev => ({ ...prev, [name]: value }))
  }

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    console.log('Form submitted:', formData)
    // TODO: Add form submission logic
  }

  return (
    <form onSubmit={handleSubmit} className="lead-form">
      <h2>Get Started with Credit Repair</h2>
      <div className="form-group">
        <label>Full Name</label>
        <input
          type="text"
          name="name"
          value={formData.name}
          onChange={handleChange}
          required
        />
      </div>
      {/* More form fields will be added here */}
      <button type="submit" className="submit-btn">
        Submit
      </button>
    </form>
  )
}

export default LeadForm