import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path'

export default defineConfig({
  plugins: [vue()],
  server: {
    port: 3000,
    open: true
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, './src')
    }
  },
  root: resolve(__dirname, './src'),
  build: {
    outDir: resolve(__dirname, './dist'),
    emptyOutDir: true
  }
})