interface PollOption {
  id: number;
  text: string;
  votes: number;
}

const pollOptions: PollOption[] = [
  { id: 1, text: 'Option 1', votes: 0 },
  { id: 2, text: 'Option 2', votes: 0 },
  { id: 3, text: 'Option 3', votes: 0 }
];

function renderPoll() {
  const app = document.getElementById('app')!;
  app.innerHTML = `
    <div class="poll-container">
      <h1>Vote for your favorite option</h1>
      <div class="options">
        ${pollOptions.map(option => `
          <div class="option" data-id="${option.id}">
            <button class="vote-btn">Vote</button>
            <span>${option.text}</span>
          </div>
        `).join('')}
      </div>
      <button id="show-results">View Results</button>
      <div id="results" class="hidden"></div>
    </div>
  `;

  document.querySelectorAll('.vote-btn').forEach(btn => {
    btn.addEventListener('click', (e) => {
      const optionId = parseInt((e.target as HTMLElement).closest('.option')!.getAttribute('data-id')!);
      pollOptions.find(o => o.id === optionId)!.votes++;
      alert('Vote recorded!');
    });
  });

  document.getElementById('show-results')!.addEventListener('click', showResults);
}

function showResults() {
  const resultsDiv = document.getElementById('results')!;
  resultsDiv.innerHTML = `
    <h2>Current Results</h2>
    ${pollOptions.map(option => `
      <div class="result">
        <span>${option.text}: ${option.votes} votes</span>
      </div>
    `).join('')}
  `;
  resultsDiv.classList.remove('hidden');
}

renderPoll();